﻿using System.Collections.Generic;
using VA.TMP.Integration.Schema.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Serialize VMR step.
    /// </summary>
    public class SerializeVmrStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            state.VirtualMeetingRoom = new VirtualMeetingRoomType
            {
                Version = "1.0",
                AppointmentId = state.VideoOnDemandId.ToString(),
                PatientName = state.PatientId.ToString(),
                ProviderName = state.ProviderId.ToString(),
                MeetingRoomName = state.MeetingRoomName,
                PatientPin = state.PatientPin,
                ProviderPin = state.ProviderPin,
                StartDate = state.AppointmentStartDate,
                EndDate = state.AppointmentEndDate,
                MiscData = state.MiscDataForRequest
            };

            state.SerializedVirtualMeetingRoom = Shared.PipelineUtilities.SerializeInstance(state.VirtualMeetingRoom, new List<string> { "vmr" }, 
                new List<string> { "http://DNS   /vyopta/schemas/exchange/VirtualMeetingRoom/1.0" });
        }
    }
}